//This program solves the s-wave radial Schrodinger equation for the vibrations of hydrogen molecule for the Morse potential
//Find the lowest vibrational energy (in MeV) of the molecule. Also plot the corresponding wave function. //Take: m = 940x106 eV/c2, D = 0.755501 eV, α = 1.44, r0 = 0.131349 Å //Where μ  s the reduced mass of the two-atom system for the Morse potential //Find the lowest vibrational energy (in MeV) of the molecule to an accuracy of three significant digits. Also plot the  // corresponding wave function. //Take: m = 940x106 eV/c2, D = 0.755501 eV, α = 1.44, ro = 0.131349 Å

clear
close
clc

//Declaring the values of constants
hcutc=1973 //Planck's constant h divided by 2*pi (hcut=h/2*pi).This when multiplied by speed of light c gives hcutc(in units of eV A)
mcsq=940*10^6; //mass*c^2 in units of eV/c^2

x0=0.131349 //In units of Angstrom
alpha=1.44 //a*x0 where 'a' is a constant for particular molecule
D=0.755501 //Dissociation Energy In units of eV

//Getting values of x to plot 'V(x)' v/s 'x' plot
xmin=0.05; //in units of A^o
xmax=1; //in units of A^o

n=input("Enter the number of intervals(should be around 500 to 1000 for good computation)");
s=(xmax-xmin)/n; //step size

for i=1:1:n
x(1,i)=xmin+s*(i-1); //x vector of 1 row and n columns to input values of internuclear seperation
x_(1,i)=(x(1,i)-x0)/x0 //x_ vector= (x-x0)/x0
end

factor1=-(hcutc^2)/(2*mcsq*s^2) //this factor is (hcut^2*c^2/2*m*c^2*s^2)

//plot of potential V(x) v/s x
V=zeros(n,n); //Potential energy matrix
for i=1:1:n
V_matrix(i,i)=(D*(1-exp(-alpha*x_(1,i)))^2) //formula for potential
end

for j=1:1:size(V_matrix,2)
V_vec(1,j)=V_matrix(j,j)
end
plot(x,(V_vec),"linewidth",2) //linewidth command to set width of line
title("Plot of first four Energy eigenvalues and Probability density for eigenfunctions","fontsize",2) //title of the plot
xlabel('Internuclear separation- x(Angstrom)--->',"fontsize",3) //fontsize command to set the font size of labels
ylabel('Energy(MeV) ->>(And the scaled wavefunctions)',"fontsize",3)

for i=1:1:n
for j=1:1:n
if i==j then
K(i,j)=-2;
elseif i==(j-1)|i==(j+1) then
K(i,j)=1;
else
K(i,j)=0;
end
end
end
T_matrix=factor1*K; //Kinetic energy matrix
H_matrix=V_matrix+T_matrix; //Hamiltonian matrix
eval=spec(H_matrix); //eval stores the eigenvalues of matrix H
[a,b]=spec(H_matrix); //a stores the eigenvectors
disp("The Eigenvalues calculated using FDM are")
for i=1:1:4
disp(eval(i,1))
end

//Plotting the eigenvalues obtained by Numerical computation
for i=1:1:4
eval_num=eval(i)
eval_num_vec=eval_num*ones(1,n)
plot(x,eval_num_vec,'k',"linewidth",2)
end
//normalization check
normalisation=sum(a(:,1).*conj(a(:,1)));
//Plotting the first four Eigen functions (plot of mod psi square).We do the scaling of Eigen functions magnitudes by
//a factor of 15 and raise to level of eigen values to make the conventional plot with eigen values and
//eigen functions on the same line
psisq1=(1/normalisation)*(a(:,1).*conj(a(:,1)))
psisq2=(1/normalisation)*(a(:,2).*conj(a(:,2)))
psisq3=(1/normalisation)*(a(:,3).*conj(a(:,3)))
psisq4=(1/normalisation)*(a(:,4).*conj(a(:,4)))
plot(x(1,:),15*psisq1'+eval(1),'r',"linewidth",1.5)
plot(x(1,:),15*psisq2'+eval(2),'r',"linewidth",1.5)
plot(x(1,:),15*psisq3'+eval(3),'r',"linewidth",1.5)
plot(x(1,:),15*psisq4'+eval(4),'r',"linewidth",1.5)
legend([' Morse Potential Curve','Energy Eigenvalues'])
